<?php
// Load the saved .txt file
$file = 'updated_all_href_links.txt'; // Path to the uploaded file

if (file_exists($file)) {
    $content = file_get_contents($file);
    $allLinks = json_decode($content, true); // Convert JSON string back to array

    echo "<pre>Processing Links...\n";

    // Function to fetch HTML content via cURL
    function fetchHTML($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
        $html = curl_exec($ch);
        curl_close($ch);
        return $html;
    }

    // Arrays to store links based on the presence of 'sorting' class
    $withSorting = [];
    $withoutSorting = [];

    // Process each link
    foreach ($allLinks as $link) {
        echo "Processing: $link\n";

        // Fetch the HTML content
        $html = fetchHTML($link);

        // Check if the HTML could not be fetched
        if (!$html) {
            echo "Failed to fetch HTML for $link\n";
            continue;
        }

        $dom = new DOMDocument();
        libxml_use_internal_errors(true); // Suppress warnings
        $dom->loadHTML($html);
        libxml_clear_errors();

        $xpath = new DOMXPath($dom);

        // Check for the 'sorting' class
        if ($xpath->query("//h2[contains(@class, 'mb-4')]")->length > 0) {
            echo "Found 'mb-4' class in $link\n";
            $withSorting[] = $link;
        } else {
            echo "No 'mb-4' class in $link\n";
            $withoutSorting[] = $link;
        }
    }

    // Output the arrays for debugging
    echo "<pre>Links with 'mb-4' class:\n";
    print_r($withSorting);
    echo "</pre>";

    echo "<pre>Links without 'mb-4' class:\n";
    print_r($withoutSorting);
    echo "</pre>";

    //exit;

    // Save the results to separate files
    $withSortingFile = 'final_categories.txt';
    $withoutSortingFile = 'updated_all_href_links_without_sorting.txt';

    file_put_contents($withSortingFile, json_encode($withoutSorting, JSON_PRETTY_PRINT));
    file_put_contents($withoutSortingFile, json_encode($withSorting, JSON_PRETTY_PRINT));

    echo "Links with 'sorting' class saved to $withoutSortingFile.\n";
    echo "Links without 'sorting' class saved to $withSortingFile.\n";
} else {
    echo "File $file not found.";
}
?>
